function tran = processTransmissionMaps(tran)

switch tran.lossMethod
    case 'eff'
        % Unimplemented

    case 'trqLossMap'
        if isfield(tran, 'gear')
            for n = 1:length(tran.gear)
                tran.gear(n).trqLossMap = processMap(tran.gear(n).trqLossMap, tran.gear(n).spdRatio);
            end
        else
            tran.trqLossMap = processMap(tran.trqLossMap, tran.spdRatio);
        end

end

end

function newMap = processMap(oldMap, spdRatio)
        spdIn = oldMap.GridVectors{1};
        trqIn = oldMap.GridVectors{2};
        [spdIn, trqIn] = ndgrid(spdIn, trqIn);

        % Evaluate triplets (spdOut, trqOut, lossTrqVal)
        lossTrqVal = oldMap.Values;
        trqOut = spdRatio .* ( trqIn - lossTrqVal );
        spdOut = spdIn ./ spdRatio;

        % Define new breakpoints
        spdBrk = linspace(0, max(spdOut(:)), 50);
        trqBrk = linspace(min(trqOut(:)), max(trqOut(:)), 51);
        [spdMesh, trqMesh] = ndgrid(spdBrk, trqBrk);

        % Create new gridded interpolant and evaluate
        trqLoss = scatteredInterpolant(spdOut(:), trqOut(:), lossTrqVal(:));
        trqLossVal = trqLoss(spdMesh, trqMesh);

        newMap = griddedInterpolant({spdBrk, trqBrk}, trqLossVal);
    end